<?php declare(strict_types = 1);

namespace Ulozenka\Model\Subscribers;

use Contributte\Translation\Translator;
use EshopOrders\Model\Event\EmailEvent;
use EshopOrders\Model\Helpers\OrderHelper;
use Core\Model\Entities\EntityManagerDecorator;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Ulozenka\Model\OrdersExported;

class OrderEmailSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected EntityManagerDecorator $em,
		protected Translator             $translator,
		protected OrdersExported         $ordersExported,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.emailChangeOrderStatus' => 'emailChangeOrderStatus',

		];
	}

	public function emailChangeOrderStatus(EmailEvent $event): void
	{
		if (!OrderHelper::canSendTrackingUrl($event->status)) {
			return;
		}

		$exported = $this->ordersExported->getOrdersExported([$event->order->getId()])[$event->order->getId()] ?? null;

		if ($exported && $exported->numberPackage) {
			$event->template->trackingUrl    = $exported->getTrackingUrl();
			$event->template->trackingNumber = $exported->numberPackage;
		}
	}
}
