<?php declare(strict_types = 1);

namespace Ulozenka\Model\Subscribers;

use Core\Model\Event\Event;
use EshopOrders\AdminModule\Model\Statuses;
use EshopOrders\Model\Entities\OrderStatus;
use Exception;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Tracy\Debugger;
use Ulozenka\Model\OrderApiService;
use Ulozenka\Model\OrdersExported;

class OrderSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected Statuses        $statuses,
		protected OrdersExported  $ordersExported,
		protected OrderApiService $orderApiService,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orders.checkCompleted' => 'checkCompleted',
		];
	}

	public function checkCompleted(Event $event): void
	{
		$orders = $this->ordersExported->getOrdersNotCompleted();

		$completed = [];
		foreach ($orders as $id => $uo) {
			if ($this->orderApiService->checkCompleted($uo)) {
				$completed[] = $id;
			}
		}

		if ($completed !== []) {
			try {
				$result = $this->statuses->changeStatus($completed, OrderStatus::STATUS_FINISHED);

				if ($result) {
					$this->ordersExported->markAsCompleted($completed);
				}
			} catch (Exception$e) {
				Debugger::log('Ulozenka error - ' . $e->getMessage(), 'ordersCheckComplete');
				Debugger::log($e);
			}
		}

		$this->ordersExported->em->clear();
	}
}
