<?php declare(strict_types = 1);

namespace Ulozenka\CronModule\Presenters;

use Core\Model\Countries;
use Ulozenka\Model\UlozenkaParcels;

class DefaultPresenter extends BasePresenter
{
	/** @var Countries @inject */
	public Countries $countriesService;

	/** @var UlozenkaParcels @inject */
	public UlozenkaParcels $parcelService;

	public function actionParcelsByService(int $id, string $country): void
	{
		$data    = [];
		$country = $this->countriesService->get($country);

		foreach ($this->parcelService->getParcelsByService($id) as $id => $row) {
			if ($row->country === $country->getIso3166_1())
				$data[$id] = [
					'name' => $row->name,
				];
		}

		$this->getPresenter()->sendJson($data);
	}
}
