<?php declare(strict_types = 1);

namespace Users\AdminModule\Presenters;

use Core\AdminModule\Presenters\SecuredPresenter;

abstract class BasePresenter extends SecuredPresenter
{
	public function checkRequirements($element)
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), ['usersManager', 'adminManager']))
			$this->error();
	}
}