<?php declare(strict_types = 1);

namespace Users\AdminModule\Presenters;

use Users\AdminModule\Components\IProfileFormFactory;
use Users\Model\Users;

class ProfilePresenter extends BasePresenter
{

	/** @var Users */
	protected $usersService;

	public function __construct(Users $users)
	{
		$this->usersService = $users;
	}


	/*******************************************************************************************************************
	 * ==================================   Renders
	 */


	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault($id)
	{
		if (!$id || !($user = $this->usersService->get($id)))
			$this->error('users.userNotFound');

		$this->template->account = $user;
		$this->setTitle($this->translator->translate('users.title.myProfile'));
		$this->setHeader('users.title.myProfile','fa fa-user-friends');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentProfileForm(IProfileFormFactory $factory)
	{
		$control = $factory->create();
		if ($this->getParameter('id'))
			$control->setUser($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function() {
			$this->redirect('this');
		};

		$control['form']->onCancel['redirect'] = function() {
			$this->redirect('Default:');
		};

		return $control;
	}
}