<?php declare(strict_types = 1);

namespace Users\AdminModule\Presenters;

use Nette\Application\ForbiddenRequestException;
use Nette\Utils\Html;
use Users\AdminModule\Components\IRoleFormFactory;
use Users\Model\Roles;

class RolesPresenter extends BasePresenter
{
	/** @var Roles */
	protected $rolesService;

	public function __construct(Roles $roles)
	{
		$this->rolesService = $roles;
	}

	public function checkRequirements($element)
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'rolesManager'))
			throw new ForbiddenRequestException();
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionAdd()
	{
		$this->setTitle($this->translator->translate('users.title.newRole'));
		$this->setHeader('users.title.newRole','fa fa-user-friends');
	}

	public function actionEdit($id)
	{
		if (!$id || !($role = $this->rolesService->get($id)))
			$this->error('users.roleNotFound');

		$this->setTitle($this->translator->translate('users.title.editRole'), $role->name);
		$this->setHeader('users.title.editRole','fa fa-user-friends');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentRoleForm(IRoleFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setRole($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function() {
			$this->redirect('Default:');
		};

		$control['form']->onCancel['redirect'] = function() {
			$this->redirect('Default:');
		};

		return $control;
	}
}