<?php declare(strict_types = 1);

namespace Users\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Users\Model\Entities\Role;
use Users\Model\Entities\User;
use Users\Model\Security\IsRequired;

class UsersGrid extends BaseControl
{
	/** @var IsRequired */
	protected $isRequired;

	public function __construct(IsRequired $isRequired)
	{
		$this->isRequired = $isRequired;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();

		$qb = $this->em->getRepository(User::class)->createQueryBuilder('u');
		$grid->setDataSource($qb);

		// Columns
		$grid->addColumnText('name', 'default.name');
		$grid->addColumnText('lastname', 'default.lastName');
		$grid->addColumnText('email', 'default.email');
		$grid->addColumnText('roles', 'default.roles', 'rolesString');

		// Actions
		$grid->addAction('edit', '', 'Default:edit')->setIcon('edit')->setBsType('primary')->setRenderCondition(function($row) {
			return $this->isRequired->canEditUser($this->getPresenter()->getUser(), $row);
		});

		return $grid;
	}
}
