<?php declare(strict_types = 1);

namespace Users\FrontModule\Presenters;

use Core\FrontModule\Presenters\BasePresenter;
use Users\FrontModule\Components\ILoginFormFactory;

class LoginPresenter extends BasePresenter
{

	protected function startup()
	{
		//TODO co kdyz je uzivatel prihlaseny, ale neni to zakaznik? Odhlasit a nechat prihlasit znovu?
		if ($this->getUser()->isLoggedIn() && $this->getUser()->isAllowed('EshopOrders:Front', 'customer'))
			$this->redirect(':EshopOrders:Front:Customer:');
		parent::startup();
	}

	public function beforeRender()
	{
		parent::beforeRender();
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentLoginForm(ILoginFormFactory $factory)
	{
		return $factory->create();
	}
}
