<?php declare(strict_types = 1);

namespace Users\Model;

use Kdyby\Doctrine\EntityManager;
use Nette;
use Nette\Security\AuthenticationException;
use Nette\Security\Passwords;
use Users\Model\Entities\User;
use Users\Model\Security\FakeIdentity;

class Authenticator implements Nette\Security\IAuthenticator
{
	use Nette\SmartObject;

	/** @var EntityManager */
	private $em;

	public function __construct(EntityManager $em)
	{
		$this->em = $em;
	}

	function authenticate(array $credentials)
	{
		$email    = $credentials[self::USERNAME];
		$password = $credentials[self::PASSWORD];

		/** @var User $user */
		$user = $this->em->getRepository(User::class)->findOneBy(['email' => $email, 'isActive' => 1]);

		if (!$user) {
			throw new AuthenticationException('login.messages.badLogin', self::IDENTITY_NOT_FOUND);
		} else if (!Passwords::verify($password, $user->getPassword())) {
			throw new AuthenticationException('login.messages.badLogin', self::INVALID_CREDENTIAL);
		} else if (Passwords::needsRehash($user->getPassword())) {
			$user->setPassword(Passwords::hash($password));
			$this->em->persist($user);
			$this->em->flush($user);
		} else if ($user->isActive()) {
			return new FakeIdentity($user->getId(), User::class);
		}

		throw new AuthenticationException('login.messages.badLogin', self::IDENTITY_NOT_FOUND);
	}
}