<?php declare(strict_types = 1);

namespace Users\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Events\Subscriber;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\Http\Session;
use Nette\SmartObject;
use Users\Model\Authorizator;

class AclListener implements Subscriber
{
	use SmartObject;

	/** @var Cache */
	private $cache;

	/** @var Session */
	private $session;

	protected $fields = false;

	protected static $cleared = false;

	public function __construct(IStorage $cacheStorage, Session $session)
	{
		$this->session = $session;
		$this->cache   = new Cache($cacheStorage, Authorizator::CACHE_NAMESPACE);
	}

	public function getSubscribedEvents()
	{
		return [];
	}

	/**
	 * @ORM\PostPersist
	 * @ORM\PostUpdate
	 * @ORM\PostRemove
	 *
	 * @param                    $entity
	 * @param LifecycleEventArgs $event
	 */
	public function postHandler($entity, LifecycleEventArgs $event)
	{
		if (self::$cleared)
			return;

		bdump('clean');
		$this->cache->clean([
			Cache::TAGS => [Authorizator::CACHE_NAMESPACE],
		]);

		self::$cleared = true;
	}
}
