<?php declare(strict_types = 1);

namespace Users\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Security\IRole;

/**
 * @ORM\Entity
 * @ORM\Table(name="user_role")
 * @ORM\EntityListeners({"AclListener"})
 */
class Role implements IRole
{
	const GUEST      = 'guest';
	const USER       = 'user';
	const ADMIN      = 'admin';
	const SUPERADMIN = 'superadmin';

	const SUPER_ADMIN_ID = 1;
	const ADMIN_ID = 2;

	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=60)
	 */
	protected $name;

	/**
	 * @var Role
	 * @ORM\ManyToOne(targetEntity="Role", inversedBy="childrens")
	 * @ORM\JoinColumn(name="parent_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	protected $parent;

	/**
	 * @var Role[]
	 * @ORM\OneToMany(targetEntity="Role", mappedBy="parent")
	 */
	protected $childrens;

	public function __construct($name)
	{
		$this->name;
		$this->childrens = new ArrayCollection();
	}

	function getRoleId()
	{
		return $this->name;
	}

}
