<?php declare(strict_types = 1);

namespace Users\AdminModule\Presenters;

use Core\AdminModule\Presenters\SecuredPresenter;
use Nette\Application\ForbiddenRequestException;

abstract class BasePresenter extends SecuredPresenter
{
	public function checkRequirements($element)
	{
		parent::checkRequirements($element);
		if ($this->getName() != 'Users:Admin:Profile' && !$this->getUser()->isAllowed($this->getFullModuleName(), ['usersManager', 'adminManager']))
			throw new ForbiddenRequestException();
	}
}
