<?php declare(strict_types = 1);

namespace Users\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="user_resource")
 * @ORM\Entity
 * @ORM\EntityListeners({"AclListener"})
 */
class Resource
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=60)
	 */
	protected $name;

	public function __construct($name)
	{
		$this->name = $name;
	}

	public function getName() { return $this->name; }
}
