<?php declare(strict_types = 1);

namespace Users\Model\Security;

use Nette\Security\User as SUser;
use Users\Model\Entities\Role;
use Users\Model\Entities\User;

class IsRequired
{
	/**
	 * @param SUser $logged
	 * @param User  $user
	 *
	 * @return boolean
	 */
	public function canEditUser($logged, $user)
	{
		if ($logged->isAllowed('Users:Admin', 'adminManager') && ($logged->getIdentity()->getRoles()[0]->getId() == Role::SUPER_ADMIN_ID || !$logged->isInRole(['Admin']) && $user->getRolesId()[0] != Role::SUPER_ADMIN_ID)
			|| ($logged->isAllowed('Users:Admin', 'usersManager') && count($user->getRolesId()) == 1 && $user->getRolesId()[0] == Role::ADMIN_ID)
		)
			return true;

		return false;
	}

	/**
	 * @param SUser $logged
	 * @param int   $roleId
	 *
	 * @return boolean
	 */
	public function canSetRole($logged, $roleId)
	{
		if ($logged->isAllowed('Users:Admin', 'adminManager')
			|| ($logged->isAllowed('Users:Admin', 'usersManager') && $roleId == Role::ADMIN_ID)
		)
			return true;

		return false;
	}
}