<?php declare(strict_types = 1);

namespace Users\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Users\Model\Entities\Role;
use Users\Model\Entities\User;
use Users\Model\Security\IsRequired;
use Users\Model\Users;

class UsersGrid extends BaseControl
{
	/** @var IsRequired */
	protected $isRequired;

	/** @var Users */
	protected $usersService;

	public function __construct(IsRequired $isRequired, Users $users)
	{
		$this->isRequired   = $isRequired;
		$this->usersService = $users;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->usersService->remove($id))
			$presenter->flashMessageSuccess('default.removed');
		else
			$presenter->flashMessageDanger('default.removeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

	/*******************************************************************************************************************
	 * ==================  Components
	 */

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();

		$qb = $this->em->getRepository(User::class)->createQueryBuilder('u');
		$grid->setDataSource($qb);

		// Columns
		$grid->addColumnText('name', 'default.name');
		$grid->addColumnText('lastname', 'default.lastName');
		$grid->addColumnText('email', 'default.email');
		$grid->addColumnText('roles', 'default.roles', 'rolesString');

		// Actions
		$grid->addAction('edit', '', 'Default:edit')->setIcon('edit')->setBsType('primary')->setRenderCondition(function($row) {
			return $this->isRequired->canEditUser($this->getPresenter()->getUser(), $row);
		});
		$grid->addAction('delete', '', 'delete!')->setIcon('times')->setBsType('danger')->addClass('ajax')->setRenderCondition(function($row) {
			return $this->getPresenter()->getUser()->isAllowed('Users:Admin', 'adminManager');
		});

		return $grid;
	}
}
