<?php declare(strict_types = 1);

namespace Users\Model;

use Core\Model\Mailing\MailBuilderFactory;
use Nette\Localization\ITranslator;
use Users\Model\Entities\User;
use Users\Model\Navigation\ForgotPassword;

class UsersMailer
{
	/** @var string */
	protected $siteName;

	/** @var string */
	protected $siteEmail;

	/** @var MailBuilderFactory */
	protected $mailer;

	/** @var ITranslator */
	protected $translator;

	public function __construct(string $siteName, string $siteEmail, MailBuilderFactory $mailer, ITranslator $translator)
	{
		$this->siteName   = $siteName;
		$this->siteEmail  = $siteEmail;
		$this->mailer     = $mailer;
		$this->translator = $translator;
	}

	public function sendNewUser(User $user, string $token): void
	{
		$mail = $this->mailer->create();

		$subject = $this->translator->translate('users.emails.createUser');
		$mail->setSubject($subject);
		$mail->setParameters([
			'subject' => $subject,
			'email'   => $user->getEmail(),
			'token'   => $token,
		]);

		$file = TEMPLATES_DIR . '/Front/default/Users/_emails/newUser.latte';

		if (file_exists($file)) {
			$mail->setTemplateFile($file);
			$mail->setFrom($this->siteEmail, $this->siteName);
			$mail->addTo($user->getEmail());
			$mail->send();
		}
	}

	public function sendForgotPasswordLink(string $email, string $token): void
	{
		$mail = $this->mailer->create();

		$subject = $this->translator->translate('users.forgotPassword.subject');
		$mail->setSubject($subject);
		$mail->setParameters([
			'subject' => $subject,
			'email'   => $email,
			'token'   => $token,
		]);

		$file = TEMPLATES_DIR . '/Front/default/Users/_emails/forgotPassword.latte';

		if (file_exists($file)) {
			$mail->setTemplateFile($file);
			$mail->setFrom($this->siteEmail, $this->siteName);
			$mail->addTo($email);
			$mail->send();
		}
	}
}
