<?php declare(strict_types = 1);

namespace Users\AdminModule\Presenters;

use Nette\Utils\Html;
use Users\AdminModule\Components\IRolesGridFactory;
use Users\AdminModule\Components\IUserFormFactory;
use Users\AdminModule\Components\IUsersGridFactory;
use Users\Model\Users;

class DefaultPresenter extends BasePresenter
{
	/** @var Users */
	protected $usersService;

	public function __construct(Users $users)
	{
		$this->usersService = $users;
	}


	/*******************************************************************************************************************
	 * ==================================   Renders
	 */


	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault()
	{
		$this->setTitle($this->translator->translate('users.title.users'));
		$this->setHeader('users.title.users', 'fa fa-user-friends');
		$this['navigation']->setData(['header' => [
			[
				'title' => 'users.menu.addUser',
				'link'  => 'Default:add',
				'ico'   => 'plus',
			], [
				'title'    => 'users.menu.addRole',
				'link'     => 'Roles:add',
				'ico'      => 'plus',
				'security' => [
					'Users:Admin' => ['rolesManager'],
				],
			],
		]]);
	}

	public function actionAdd()
	{
		$this->setTitle($this->translator->translate('users.title.newUser'));
		$this->setHeader('users.title.newUser', 'fa fa-user-friends');
	}

	public function actionEdit($id)
	{
		if (!$id || !($user = $this->usersService->get($id)))
			$this->error('users.userNotFound');

		$this->setTitle($this->translator->translate('users.title.editUser'), $user->getName());
		$this->setHeader('users.title.editUser', 'fa fa-user-friends');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentUsersGrid(IUsersGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentUserForm(IUserFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setUser($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function() {
			$this->redirect('default');
		};
		$control['form']->onCancel['redirect']  = function() {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentRolesGrid(IRolesGridFactory $factory)
	{
		return $factory->create();
	}
}
