<?php declare(strict_types = 1);

namespace Users\Model;

use Core\Model\Mailing\MailBuilderFactory;
use Core\Model\Settings;
use Nette\Localization\ITranslator;
use Users\Model\Entities\User;

class UsersMailer
{
	/** @var Settings */
	protected $settings;

	/** @var MailBuilderFactory */
	protected $mailer;

	/** @var ITranslator */
	protected $translator;

	public function __construct(Settings $settings, MailBuilderFactory $mailer, ITranslator $translator)
	{
		$this->settings   = $settings;
		$this->mailer     = $mailer;
		$this->translator = $translator;
	}

	public function sendNewUser(User $user, string $token): void
	{
		$mail = $this->mailer->create();

		$subject = $this->translator->translate('users.emails.createUser');
		$mail->setSubject($subject);
		$mail->setParameters([
			'subject' => $subject,
			'email'   => $user->getEmail(),
			'token'   => $token,
		]);

		$file = TEMPLATES_DIR . '/Front/default/Users/_emails/newUser.latte';

		if (file_exists($file)) {
			$mail->setTemplateFile($file);
			$mail->setFrom($this->settings->get('siteEmail'), $this->settings->get('siteName'));
			$mail->addTo($user->getEmail());
			$mail->send();
		}
	}

	public function sendForgotPasswordLink(string $email, string $token): void
	{
		$mail = $this->mailer->create();

		$subject = $this->translator->translate('usersFront.forgotPasswordForm.subject', ['siteName' => $this->settings->get('siteName')]);
		$mail->setSubject($subject);
		$mail->setParameters([
			'subject' => $subject,
			'email'   => $email,
			'token'   => $token,
		]);

		$file = TEMPLATES_DIR . '/Front/default/Users/_emails/forgotPassword.latte';

		$mail->setTemplateFile(file_exists($file) ? $file : __DIR__ . '/../FrontModule/Components/forgotPasswordEmail.latte');
		$mail->setFrom($this->settings->get('siteEmail'), $this->settings->get('siteName'));
		$mail->addTo($email);
		$mail->send();
	}
}
