<?php declare(strict_types = 1);

namespace Users\FrontModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Forms\Form;
use Nette\Security\AuthenticationException;
use Nette\Utils\ArrayHash;
use Users\Model\UsersConfig;

class LoginForm extends BaseControl
{
	/** @var UsersConfig */
	protected $usersConfig;

	public function __construct(UsersConfig $usersConfig)
	{
		$this->usersConfig = $usersConfig;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax();

		$form->addText('email', 'login.loginForm.email')
			->setAttribute('placeholder', 'login.loginForm.email')
			->addRule(Form::EMAIL)->setRequired();
		$form->addPassword('password', 'login.loginForm.password')
			->setAttribute('placeholder', 'login.loginForm.password')->setRequired();

		$form->addSubmit('submit', 'login.loginForm.submit');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(Form $form, ArrayHash $values): bool
	{
		$presenter = $this->getPresenter();

		try {
			$presenter->getUser()->login($values->email, $values->password);
			$presenter->redirect($this->usersConfig->get('redirectAfterLogin'));
		} catch (AuthenticationException $e) {
			$form->addError($e->getMessage());

			if ($presenter->isAjax())
				$this->redrawControl('form');
			else
				return false;
		}

		return true;
	}
}
