<?php declare(strict_types = 1);

namespace Users\Model\Security;

use Nette\Security\IIdentity;

class FakeIdentity implements IIdentity
{
	/** @var mixed */
	private $id;

	/** @var string */
	private $class;

	/** @var string */
	protected $userType;

	public function __construct($id, $class, $userType = 'user')
	{
		$this->id       = $id;
		$this->class    = $class;
		$this->userType = $userType;
	}

	/**
	 * @return mixed
	 */
	public function getId()
	{
		return $this->id;
	}

	/**
	 * @return string
	 */
	public function getClass()
	{
		return $this->class;
	}

	/**
	 * @return array
	 */
	public function getRoles()
	{
		return [];
	}

	public function getUserType(): string { return $this->userType; }
}
