<?php declare(strict_types = 1);

namespace Users\Model\Security;

use Nette\Security\User as SUser;
use Users\Model\Entities\Role;
use Users\Model\Entities\User;

class IsRequired
{
	/** @var SUser */
	protected $user;

	public function __construct(SUser $user)
	{
		$this->user = $user;
	}

	public function canEditUser(User $user): bool
	{
		return $this->user->isInRole(Role::SUPERADMIN)
			|| $this->user->isAllowed('Users:Admin', 'adminManager') && !$user->isInRoleByIdent(Role::SUPERADMIN)
			|| $this->user->isAllowed('Users:Admin', 'usersManager') && !$user->isInRoleByIdent(Role::SUPERADMIN) && !$user->isInRoleByIdent(Role::ADMIN)
			|| $user->getId() === $this->user->getId();
	}

	public function canSetRole(string $ident): bool
	{
		return ($this->user->isInRole(Role::SUPERADMIN)
			|| $this->user->isInRole(Role::ADMIN && !in_array($ident, [Role::SUPERADMIN, Role::ADMIN])));
	}
}
