<?php declare(strict_types=1);

namespace Users\Model;

use Core\Model\Helpers\BaseEntityService;
use Exception;
use Nette\Utils\DateTime;
use Users\Model\Entities\User;
use Users\Model\Security\User as UserSecurity;

class UsersActivity extends BaseEntityService {

	protected $entityClass = User::class;

	/**
	 * @param UserSecurity $userSecurity
	 * @throws Exception
	 */
	public function setFirstSignIn(UserSecurity $userSecurity): void
	{
		$user = $this->get((int) $userSecurity->getId());

		if ($user->getFirstSignIn() !== null) {
			return;
		}

		$user->firstSignIn = new DateTime;

		$this->em->persist($user)
		         ->flush($user);
	}

	/**
	 * @param int $userId
	 * @throws Exception
	 */
	public function setLastActivity(int $userId): void {
		$qb = $this->em->createQueryBuilder();
		$qb->update($this->entityClass, 'u')
		   ->set('u.lastActivity', $qb->expr()->literal(new DateTime))
		   ->where('u.id = :userId')
		   ->setParameter('userId', $userId);

		$qb->getQuery()->execute();
	}

}