<?php declare(strict_types = 1);

namespace Users\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Nette\Forms\Form;
use Nette\Security\AuthenticationException;
use Nette\Utils\ArrayHash;

class LoginForm extends BaseControl
{
	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addText('email', 'login.loginForm.email')
			->setAttribute('placeholder', 'login.loginForm.email')
			->addRule(Form::EMAIL)->setRequired();
		$form->addPassword('password', 'login.loginForm.password')
			->setAttribute('placeholder', 'login.loginForm.password')->setRequired();
		$form->addHidden('url', $this->getPresenter()->getHttpRequest()->getUrl()->getAbsoluteUrl());

		$form->addSubmit('submit', 'login.loginForm.submit');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(Form $form, ArrayHash $values)
	{
		$presenter = $this->getPresenter();

		try {
			$presenter->getUser()->login($values->email, $values->password);
			if ($values->url)
				$presenter->redirectUrl($values->url);
			else
				$presenter->redirect(':Dashboard:Admin:Default:');
		} catch (AuthenticationException $e) {
			$form->addError($e->getMessage());

			if ($presenter->isAjax())
				$this->redrawControl('form');
			else
				return false;
		}
	}
}
