<?php declare(strict_types = 1);

namespace Users\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="user_acl")
 * @ORM\Entity
 * @ORM\EntityListeners({"AclListener"})
 */
class Acl
{
	use TId;

	/**
	 * @var Role
	 * @ORM\ManyToOne(targetEntity="Role")
	 * @ORM\JoinColumn(name="role_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $role;

	/**
	 * @var Privilege
	 * @ORM\ManyToOne(targetEntity="Privilege")
	 * @ORM\JoinColumn(name="privilege_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $privilege;

	/**
	 * @var Resource
	 * @ORM\ManyToOne(targetEntity="Resource")
	 * @ORM\JoinColumn(name="resource_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $resource;

	/**
	 * @var int
	 * @ORM\Column(name="allowed", type="smallint")
	 */
	public $allowed;

	public function __construct($role, $resource, $privilege, $allowed = 1)
	{
		$this->role      = $role;
		$this->resource  = $resource;
		$this->privilege = $privilege;
		$this->allowed   = $allowed;
	}
}
