<?php declare(strict_types = 1);

namespace Users\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="user_resource")
 * @ORM\Entity
 * @ORM\EntityListeners({"AclListener"})
 */
class Resource
{
	use TId;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=60)
	 */
	public $name;

	public function __construct($name)
	{
		$this->name = $name;
	}
}
