<?php declare(strict_types = 1);

namespace Users\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;
use Nette\Security\IRole;

/**
 * @ORM\Entity
 * @ORM\Table(name="user_role")
 * @ORM\EntityListeners({"AclListener"})
 */
class Role implements IRole
{
	const GUEST      = 'guest';
	const USER       = 'user';
	const ADMIN      = 'admin';
	const SUPERADMIN = 'superAdmin';

	use TId;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=60)
	 */
	public $name;

	/**
	 * @var string
	 * @ORM\Column(name="ident", type="string", length=60)
	 */
	public $ident;

	/**
	 * @var Role
	 * @ORM\ManyToOne(targetEntity="Role", inversedBy="childrens")
	 * @ORM\JoinColumn(name="parent_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	public $parent;

	/**
	 * @var Role[]
	 * @ORM\OneToMany(targetEntity="Role", mappedBy="parent")
	 */
	protected $childrens;

	public function __construct($name)
	{
		$this->name;
		$this->childrens = new ArrayCollection();
	}

	function getRoleId(): string
	{
		return $this->name;
	}

}
