<?php declare(strict_types = 1);

namespace Users\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Nette\Forms\Form;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use Users\Model\Entities\User;

class ProfileForm extends BaseControl
{
	/** @var User */
	public $user;

	public function render()
	{
		if (!$this->user)
			return '';

		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addText('name', 'default.name')->setRequired();
		$form->addText('lastname', 'default.lastName')->setRequired();
		$form->addPassword('password', 'default.password')->setRequired();
		$form->addEmail('email', 'default.email')->setRequired();

		$form->addSubmit('submit', 'default.save');
		$form->addCancel('cancel', 'default.cancel');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(Form $form, ArrayHash $values)
	{
		try {
			$user = $this->user ?: new User($values->email, $values->password);

			$user->setName($values->name);
			$user->setLastname($values->lastname);
			$user->setEmail($values->email);

			if ($values->password != '')
				$user->setPassword($values->password);

			$this->getPresenter()->flashMessageSuccess('users.profileForm.profileUpdated');
			$this->em->persist($user)->flush();
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	public function setUser($id)
	{
		$this->user = $this->em->getRepository(User::class)->find($id);

		if ($this->user) {
			$this['form']->setDefaults([
				'name'     => $this->user->getName(),
				'lastname' => $this->user->getLastname(),
				'email'    => $this->user->getEmail(),
			]);

			$this['form']['password']->setRequired(false);
		} else {
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
		}
	}
}
