<?php declare(strict_types = 1);

namespace Users\FrontModule\Components;

use Core\Model\UI\Form\BaseForm;
use Nette\Forms\Form;
use Nette\Utils\ArrayHash;
use Core\Model\UI\BaseControl;
use Users\Model\Users;

class ForgotPasswordForm extends BaseControl
{
	/** @var Users */
	protected $usersService;

	public function __construct(Users $usersService)
	{
		$this->usersService = $usersService;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax();

		$form->addText('email', 'usersFront.forgotPasswordForm.email')
			->addRule(Form::EMAIL)->setRequired();

		$form->addSubmit('submit', 'usersFront.forgotPasswordForm.submit');

		$form->onValidate[] = [$this, 'formOnValidate'];
		$form->onSuccess[]  = [$this, 'formSuccess'];

		return $form;
	}

	public function formOnValidate(Form $form, ArrayHash $values): void
	{
		$user = $this->usersService->getByEmail($values->email);

		if (!$user) {
			$form->addError('usersFront.forgotPasswordForm.notExists');
			$this->redrawControl('form');
		}
	}

	public function formSuccess(Form $form, ArrayHash $values): bool
	{
		$presenter = $this->getPresenter();

		try {
			$this->usersService->createForgotPasswordAction($values->email);

			$this->getPresenter()->flashMessageSuccess('usersFront.forgotPasswordForm.sent');
			$this->getPresenter()->redrawControl('flashes');
			$form->reset();
			$this->redrawControl('form');
		} catch (\Exception $e) {
			$form->addError('usersFront.forgotPasswordForm.error');

			if ($presenter->isAjax())
				$this->redrawControl('form');
			else
				return false;
		}

		return true;
	}
}
