<?php declare(strict_types = 1);

namespace Users\Model;

class UsersConfig
{
	/** @var array */
	protected $params;

	/** @var string */
	protected $separator = '.';

	/**
	 * SystemConfig constructor.
	 *
	 * @param $params
	 */
	public function __construct(array $params)
	{
		$this->params = $params;
	}

	/**
	 * @param string $key
	 * @param mixed  $default
	 *
	 * @return mixed|null
	 */
	public function get(string $key, $default = null)
	{
		$keys = explode($this->separator, $key);
		$arr  = $this->params;

		foreach ($keys as $key) {
			if (!isset($arr[$key]))
				return $default;
			$arr = &$arr[$key];
		}

		return $arr ?? $default;
	}
}
