<?php declare(strict_types = 1);

namespace Users\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Doctrine\ORM\QueryBuilder;
use Users\Model\Entities\Role;
use Users\Model\Entities\User;
use Users\Model\Roles;
use Users\Model\Security\IsRequired;
use Users\Model\Users;
use Users\Model\UsersConfig;

class UsersGrid extends BaseControl
{
	/** @var IsRequired */
	protected $isRequired;

	/** @var Users */
	protected $usersService;

	/** @var Roles */
	protected $rolesService;

	public function __construct(IsRequired $isRequired, Users $users, Roles $roles)
	{
		$this->isRequired   = $isRequired;
		$this->usersService = $users;
		$this->rolesService = $roles;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->usersService->remove($id))
			$presenter->flashMessageSuccess('default.removed');
		else
			$presenter->flashMessageDanger('default.removeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

	/*******************************************************************************************************************
	 * ==================  Components
	 */

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();

		$qb = $this->em->getRepository(User::class)->createQueryBuilder('u')
		->leftJoin('u.roles', 'roles');
		$grid->setDataSource($qb);

		// Columns
		$grid->addColumnText('name', 'default.name')
			->setFilterText();
		$grid->addColumnText('lastname', 'default.lastName')
			->setFilterText();
		$grid->addColumnText('email', 'default.email')
			->setFilterText();
		$grid->addColumnText('roles', 'default.roles', 'rolesString')
		->setFilterSelect([null => ''] + $this->rolesService->getForSelectOptions(), 'roles.id');
//			->setCondition(function(QueryBuilder $qb, $value) {
//				$qb->andWhere('u.roles = :role')->setParameter('role', $value);
//			});
		if (UsersConfig::load('usersGrid.showLastActivityInAdmin', false)) {
			$grid->addColumnDateTime('lastActivityInAdmin', 'users.usersGrid.lastActivityInAdmin')
				 ->setAlign('left')
				 ->setFitContent()
				 ->setFormat('d.m.Y H:i');
		}

		// Actions
		$grid->addAction('edit', '', 'Default:edit')->setIcon('edit')->setBsType('primary')->setRenderCondition(function($row) {
			return $this->isRequired->canEditUser($row);
		});
		$grid->addAction('delete', '', 'delete!')->setIcon('times')->setBsType('danger')->addClass('ajax')->setRenderCondition(function(User $row) {
			return $this->isRequired->canEditUser($row) && $row->getId() !== $this->getPresenter()->getUser()->getId();
		})->setConfirm('default.reallyDelete');

		return $grid;
	}
}
