<?php declare(strict_types = 1);

namespace Users\ApiModule\Api\V1\Controllers;

use Apitte\Core\Annotation\Controller\GroupPath;
use Apitte\Core\Http\ApiResponse;
use Apitte\Core\UI\Controller\IController;
use Apitte\Negotiation\Http\ArrayEntity;

/**
 * Class BaseController
 * @package Users\Api\V1\Controllers
 *
 * @GroupPath("/api/v1/eshoporders")
 */
abstract class BaseController implements IController
{
	public function sendError(ApiResponse $response, string $message, int $code = 404): ApiResponse
	{
		$response = $response->withStatus($code)
			->withEntity(ArrayEntity::from([
				'status'  => 'error',
				'message' => $message,
			]));
		return $response;
	}
}
