<?php declare(strict_types = 1);

namespace Users\Model;

use Core\Model\SystemConfig;
use Core\Model\Entities\EntityManagerDecorator;
use Nette;
use Nette\Security\AuthenticationException;
use Nette\Security\IIdentity;
use Nette\Security\Passwords;
use Users\Model\Entities\User;
use Users\Model\Security\FakeIdentity;

class Authenticator implements Nette\Security\IAuthenticator
{
	use Nette\SmartObject;

	/** @var string */
	protected $identityClass = User::class;

	/** @var string */
	protected $userType = 'user';

	/** @var EntityManagerDecorator */
	protected $em;

	/** @var SystemConfig */
	protected $systemConfig;

	public function __construct(EntityManagerDecorator $em, SystemConfig $systemConfig)
	{
		$this->em           = $em;
		$this->systemConfig = $systemConfig;
	}

	function authenticate(array $credentials): IIdentity
	{
		$password = $credentials[self::PASSWORD];

		/** @var User $user */
		$user = $this->findUser($credentials);

		$passwords = new Passwords();

		if (!$user) {
			throw new AuthenticationException('login.messages.badLogin', self::IDENTITY_NOT_FOUND);
		} else if (!$passwords->verify($password, $user->getPassword())) {
			throw new AuthenticationException('login.messages.badLogin', self::INVALID_CREDENTIAL);
		} else if ($passwords->needsRehash($user->getPassword())) {
			$user->setPassword($passwords->hash($password));
			$this->em->persist($user);
			$this->em->flush($user);
		} else if ($user->isActive()) {
			//			$hasAccess = false;
			//			foreach ($user->getRoles() as $role) {
			//				if (in_array($role, $this->systemConfig->get('adminRoles'))) {
			//					$hasAccess = true;
			//					break;
			//				}
			//			}
			//
			//			if (!$hasAccess)
			//				throw new AuthenticationException('login.messages.forbidden', self::NOT_APPROVED);

			return new FakeIdentity($user->getId(), $this->identityClass, $this->userType);
		}

		throw new AuthenticationException('login.messages.badLogin', self::IDENTITY_NOT_FOUND);
	}

	protected function findUser($credentials)
	{
		$email    = $credentials[self::USERNAME];
		$password = $credentials[self::PASSWORD];

		return $this->em->getRepository(User::class)->findOneBy(['email' => $email, 'isActive' => 1]);
	}
}
