<?php declare(strict_types = 1);

namespace Users\Model\Http;

use Core\Model\Entities\EntityManagerDecorator;
use Nette\Http\Session;
use Nette\Security\IIdentity;
use Users\Model\Security\FakeIdentity;
use Users\Model\Users;

class UserStorage extends \Nette\Http\UserStorage
{
	protected EntityManagerDecorator $em;

	protected Users $users;

	public function __construct(Session $sessionHandler, EntityManagerDecorator $entityManager, Users $users)
	{
		parent::__construct($sessionHandler);
		$this->em    = $entityManager;
		$this->users = $users;
	}

	/**
	 * Sets the user identity.
	 * @return UserStorage Provides a fluent interface
	 */
	public function setIdentity(IIdentity $identity = null)
	{
		if ($identity !== null) {
			$class = get_class($identity);

			// we want to convert identity entities into fake identity
			// so only the identifier fields are stored,
			// but we are only interested in identities which are correctly
			// mapped as doctrine entities
			if ($this->em->getMetadataFactory()->hasMetadataFor($class)) {
				$cm         = $this->em->getClassMetadata($class);
				$identifier = $cm->getIdentifierValues($identity);
				$identity   = new FakeIdentity($identifier, $class);
			}
		}

		return parent::setIdentity($identity);
	}

	public function getIdentity(): ?IIdentity
	{
		$identity = parent::getIdentity();

		// if we have our fake identity, we now want to
		// convert it back into the real entity
		// returning reference provides potentially lazy behavior
		if ($identity instanceof FakeIdentity) {
			return $this->users->get($identity->getId());
		}

		return $identity;
	}

	public function getUserType(): ?string
	{
		$identity = parent::getIdentity();

		if ($identity instanceof FakeIdentity) {
			return $identity->getUserType();
		}

		return null;
	}
}
