<?php declare(strict_types = 1);

namespace Users\Model;

use Core\Model\Helpers\BaseEntityService;
use Users\Model\Entities\Role;

/**
 * Class Roles
 * @package Users\Model
 *
 * @method Role|null|object = getReference($id)
 * @method Role[]|null getAll()
 * @method Role|null get($id)
 */
class Roles extends BaseEntityService
{
	protected $entityClass = Role::class;

	public function getByIdent($ident)
	{
		$query = $this->getEr()->createQueryBuilder('r', 'r.id')
			->andWhere('r.ident = :ident')->setParameter('ident', $ident);

		return $query->getQuery()->setMaxResults(1)->getOneOrNullResult();
	}

	public function remove(int $id): bool
	{
		if ($entity = $this->get($id)) {
			if ($entity->ident == Role::SUPERADMIN)
				return false;
			$this->em->remove($entity);
			$this->em->flush();

			return true;
		}

		return false;
	}

	public function getForSelectOptions(): array
	{
		return $this->getEr()->findPairs([], 'name', ['name'], 'id');
	}
}
