<?php declare(strict_types=1);

namespace Users\Model;

use Core\Model\Helpers\BaseEntityService;
use Exception;
use Nette\Utils\DateTime;
use Users\Model\Entities\User;
use Users\Model\Security\User as UserSecurity;

class UsersActivity extends BaseEntityService {

	protected $entityClass = User::class;

	/**
	 * @param UserSecurity $userSecurity
	 * @throws Exception
	 */
	public function setFirstSignIn(UserSecurity $userSecurity): void
	{
		/** @var User $user */
		$user = $this->get((int) $userSecurity->getId());

		if ($user->getFirstSignIn() !== null) {
			return;
		}

		$user->setFirstSignIn(new DateTime);

		$this->em->persist($user)
		         ->flush($user);
	}

	/**
	 * @param int $userId
	 * @throws Exception
	 */
	public function setLastActivity(int $userId): void {
		$qb = $this->em->createQueryBuilder();
		$qb->update($this->entityClass, 'u')
		   ->set('u.lastActivity', $qb->expr()->literal(new DateTime))
		   ->where('u.id = :userId')
		   ->setParameter('userId', $userId);

		$qb->getQuery()->execute();
	}

	public function setLastActivityInAdmin(int $userId, bool $performanceMode = false): void
	{
		if (!$performanceMode) {
			$qb = $this->em->createQueryBuilder();
			$qb->update($this->entityClass, 'u')
			   ->set('u.lastActivityInAdmin', $qb->expr()->literal(new DateTime))
			   ->where('u.id = :userId')
			   ->setParameter('userId', $userId);

			$qb->getQuery()->execute();
		} else {
			$tableName = $this->em->getClassMetadata($this->entityClass)->getTableName();
			$this->em->getConnection()->executeQuery("UPDATE {$tableName} SET last_activity_in_admin = now() WHERE id = ?", [$userId]);
		}
	}

}
