<?php declare(strict_types = 1);

namespace Users\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Users\Model\Entities\Role;
use Users\Model\Roles;

class RolesGrid extends BaseControl
{

	/** @var Roles */
	protected $rolesService;

	public function __construct(Roles $roles)
	{
		$this->rolesService = $roles;
	}

	public function render()
	{
		if (!$this->getPresenter()->getUser()->isAllowed('Users:Admin', 'rolesManager'))
			return '';

		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->rolesService->remove($id))
			$presenter->flashMessageSuccess('default.removed');
		else
			$presenter->flashMessageDanger('default.removeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

	/*******************************************************************************************************************
	 * ==================  Components
	 */

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();

		$qb = $this->em->getRepository(Role::class)->createQueryBuilder('u');
		$grid->setDataSource($qb);

		// Columns
		$grid->addColumnLink('name', 'users.rolesGrid.name', 'Roles:edit');
		$grid->addColumntext('ident', 'users.rolesGrid.ident');

		// Actions
		$grid->addAction('edit', '', 'Roles:edit')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setIcon('times')->setBsType('danger')->addClass('ajax');

		return $grid;
	}
}
