<?php declare(strict_types = 1);

namespace Users\FrontModule\Presenters;

use Core\FrontModule\Presenters\BasePresenter;
use Users\FrontModule\Components\ILoginFormFactory;
use Users\FrontModule\Components\IForgotPasswordFormFactory;
use Users\FrontModule\Components\INewPasswordFormFactory;
use Users\FrontModule\Components\ForgotPasswordForm;

class LoginPresenter extends BasePresenter
{

	protected function startup()
	{
		parent::startup();
	}

	public function beforeRender()
	{
		parent::beforeRender();
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */
	
	public function actionDefault()
	{
		//TODO co kdyz je uzivatel prihlaseny, ale neni to zakaznik? Odhlasit a nechat prihlasit znovu?
		if ($this->getUser()->isLoggedIn() && $this->getUser()->isAllowed('EshopOrders:Front', 'customer'))
			$this->redirect(':EshopOrders:Front:Customer:');
		
		$this->template->messages         = $this->getTemplate()->flashes;
		$this->getTemplate()->flashes     = [];
	}
	
	public function actionForgotPassword()
	{
	}
	
	public function actionNewPassword()
	{
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */
	
	protected function createComponentLoginForm(ILoginFormFactory $factory)
	{
		return $factory->create();
	}
	
	protected function createComponentForgotPasswordForm(IForgotPasswordFormFactory $factory)
	{
		return $factory->create();
	}
	
	protected function createComponentNewPasswordForm(INewPasswordFormFactory $factory)
	{
		return $factory->create();
	}
}
