<?php declare(strict_types = 1);

namespace Users\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;

/**
 * @ORM\Entity
 * @ORM\Table(name="user_action")
 */
class UserAction
{
	const RESET_PASSWORD    = 'resetPassword';
	
	use Identifier;
	use MagicAccessors;
	
	/**
	 * @var string
	 * @ORM\Column(name="type", type="string")
	 */
	protected $type;
	
	/**
	 * @var DateTime
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(name="created", type="datetime")
	 */
	protected $created;
	
	/**
	 * @var string
	 * @ORM\Column(name="token", type="string", length=255, nullable = false)
	 */
	protected $token;
	
	/**
	 * @var boolean
	 * @ORM\Column(name="done", type="boolean", nullable=false)
	 */
	protected $done;
	
	/**
	 * @var User
	 * @ORM\ManyToOne(targetEntity="User")
	 * @ORM\JoinColumn(name="user_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $user;
	
	public function __construct(User $user, $type, $token)
	{
		$this->user    = $user;
		$this->type    = $type;
		$this->token   = $token;
		$this->created = new DateTime();
		$this->done    = false;
	}
	
	public function getType()
	{
		return $this->type;
	}
	
	public function getCreated()
	{
		return $this->created;
	}
	
	public function getToken()
	{
		return $this->token;
	}
	
	public function isDone()
	{
		return $this->done;
	}
	
	public function setDone($done): UserAction
	{
		$this->done = $done;
		return $this;
	}
	
	public function getUser()
	{
		return $this->user;
	}

}
