<?php declare(strict_types = 1);

namespace Users\Model\Navigation;

use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;

class ForgotPassword extends BaseNavigation implements INavigationItem
{
	protected $title                  = 'forgotPassword';
	protected $presenter              = 'Users:Front:Login';
	protected $action                 = 'forgotPassword';
	protected $actionReset            = 'newPassword';
	
	public const URL_RESET = 'nove-heslo';
	
	/**
	 * @return BaseContainer
	 */
	public function getFormContainer()
	{
		$container = new BaseContainer();
		
		return $container;
	}
	
	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		if ($this->presenter == $presenter && $this->action == $action)
			return 1;
		elseif ($this->presenter == $presenter && $this->actionReset == $action)
			return 2;

		return false;
	}

	public function routerIn($navigation, $urlParams = [])
	{
		if(isset($urlParams['path'])) {
			$params = explode('/', $urlParams['path']);
			$lastSegment = array_pop($params);
			
			if($lastSegment == self::URL_RESET) {
				return [
					'presenter' => $this->presenter,
					'action'    => $this->actionReset,
					'id'        => null,
				];
			}
		}
		
		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => null,
		];
	}

	public function routerOut($navigation, &$urlParams)
	{
		if ($navigation instanceof Navigation == false)
			return false;
		
		$urlParts = [];
		if (!$navigation->isHomepage)
			$urlParts[] = $navigation->alias;
		
		if($urlParams['action'] == $this->actionReset) {
			$urlParts[] = self::URL_RESET;
		}
		
		return '/' . implode('/', $urlParts);
	}
}
