<?php declare(strict_types = 1);

namespace Users\Model;

use Core\Model\Helpers\BaseEntityService;
use Users\Model\Entities\User;

/**
 * Class Users
 * @package Users\Model
 *
 * @method User|null|object = getReference($id)
 * @method User[]|null getAll()
 * @method User|null get($id)
 */
class Users extends BaseEntityService
{
	protected $entityClass = User::class;
	
	/** @return User|null */
	public function getByEmail($email)
	{
		$query = $this->getEr()->createQueryBuilder('u', 'u.id');
		$query->andWhere('u.email = :email')->setParameter('email', $email);
		$user = $query->getQuery()->getOneOrNullResult();
		
		return $user;
	}
	
	/** Najde nebo vytvori uzivatele.
	 * Nejprve hleda prihlaseneho uzivatel. Kdyz neni, tak hleda podle emailu. Kdyz nenajde, vytvori uzivatele se zadanymi parametry
	 *
	 * @param int|null $userId
	 * @param string $email
	 * @param string $firstName
	 * @param string $lastName
	 * @return User
	 */
	public function getOrCreateUser($userId, $email, $firstName = '', $lastName = '')
	{
		if($userId) {
			$user = $this->get($userId);
		} else {
			$user = $this->getByEmail($email);
			if(!$user) {
				
				$randomPassword = md5(uniqid(random_bytes(5), true));
				$user = new User($firstName, $email, $randomPassword);
				$user->setLastname($lastName);
				$this->em->persist($user)->flush();
			}
		}
		return $user;
	}
}
