<?php declare(strict_types = 1);

namespace Users\AdminModule\Presenters;

use Core\AdminModule\Presenters\BasePresenter;
use Users\AdminModule\Components\ILoginFormFactory;

class LoginPresenter extends BasePresenter
{

	protected function startup()
	{
		if ($this->getUser()->isLoggedIn())
			$this->redirect(':Dashboard:Admin:Default:');
		parent::startup();
	}

	public function beforeRender()
	{
		parent::beforeRender();
		$this->setTitle($this->t('login.title'));
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentLoginForm(ILoginFormFactory $factory)
	{
		return $factory->create();
	}
}
