<?php declare(strict_types = 1);

namespace Users\DI;

use Core\DI\CompilerExtension;
use Nette;

class UsersExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		Nette\DI\Compiler::loadDefinitions(
			$this->getContainerBuilder(),
			$this->loadFromFile(__DIR__ . '/services.neon')
		);
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Users' => 'Users\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();

		$builder->getDefinition('users.admin.roleFormFactory')->setArguments([$builder->parameters['acl']]);

		// Nespouštět aktualizaci oprávnění pokud se jedná o CLI
		if (php_sapi_name() !== 'cli') {
			$authorizator = $builder->getDefinition('authorizator');
			$authorizator->addSetup('setAcl', [$builder->parameters['acl'] ?: []]);
		}
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init    = $class->methods["initialize"];
		$builder = $this->getContainerBuilder();

		$init->addBody('Users\Model\UsersConfig::setParams(?);', [$builder->parameters['users']]);
	}
}
