<?php declare(strict_types=1);

namespace Users\Model\Entities;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\FileSystem;

class UserListener
{
	/**
	 * @ORM\PreRemove
	 * @param User               $user
	 * @param LifecycleEventArgs $events
	 */
	public function preRemoveHandler(User $user, LifecycleEventArgs $events): void
	{
		$entityManager = $events->getEntityManager();

		if ($user->getProfileImage() !== null) {
			FileSystem::delete($user->getProfileImage());
		}
	}
}