<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20180801010101 extends AbstractMigration
{
	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('CREATE TABLE user_acl (id INT AUTO_INCREMENT NOT NULL, role_id INT DEFAULT NULL, privilege_id INT DEFAULT NULL, resource_id INT DEFAULT NULL, allowed SMALLINT NOT NULL, INDEX IDX_57960C99D60322AC (role_id), INDEX IDX_57960C9932FB8AEA (privilege_id), INDEX IDX_57960C9989329D25 (resource_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE user_privilege (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(60) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE user_resource (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(60) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE user_role (id INT AUTO_INCREMENT NOT NULL, parent_id INT DEFAULT NULL, name VARCHAR(60) NOT NULL, INDEX IDX_2DE8C6A3727ACA70 (parent_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE user (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(60) NOT NULL, alias VARCHAR(60) NOT NULL, password VARCHAR(60) NOT NULL, email VARCHAR(60) DEFAULT NULL, is_active SMALLINT NOT NULL, created DATETIME NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE user_roles (user_id INT NOT NULL, role_id INT NOT NULL, INDEX IDX_54FCD59FA76ED395 (user_id), INDEX IDX_54FCD59FD60322AC (role_id), PRIMARY KEY(user_id, role_id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');

		$this->addSql('ALTER TABLE user_acl ADD CONSTRAINT FK_57960C99D60322AC FOREIGN KEY (role_id) REFERENCES user_role (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE user_acl ADD CONSTRAINT FK_57960C9932FB8AEA FOREIGN KEY (privilege_id) REFERENCES user_privilege (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE user_acl ADD CONSTRAINT FK_57960C9989329D25 FOREIGN KEY (resource_id) REFERENCES user_resource (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE user_role ADD CONSTRAINT FK_2DE8C6A3727ACA70 FOREIGN KEY (parent_id) REFERENCES user_role (id) ON DELETE SET NULL');
		$this->addSql('ALTER TABLE user_roles ADD CONSTRAINT FK_54FCD59FA76ED395 FOREIGN KEY (user_id) REFERENCES user (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE user_roles ADD CONSTRAINT FK_54FCD59FD60322AC FOREIGN KEY (role_id) REFERENCES user_role (id) ON DELETE CASCADE');

		$this->addSql('INSERT INTO `user` VALUES (\'1\', \'PSHK\', \'pshk\', \'$2y$10$xFubc2fBeWy/mPl0S20UwebGvoTU6P80MlTLjyBUoqdS0yEPHZkAW\', \'webmaster@pshk.cz\', \'1\', \'2018-08-21 15:32:20\')');
		$this->addSql('INSERT INTO `user_role` VALUES (\'1\', null, \'Super admin\')');
		$this->addSql('INSERT INTO `user_privilege` VALUES (\'1\', \'all\')');
		$this->addSql('INSERT INTO `user_privilege` VALUES (\'2\', \'access\')');
		$this->addSql('INSERT INTO `user_resource` VALUES (\'1\', \'all\')');
		$this->addSql('INSERT INTO `user_roles` VALUES (\'1\', \'1\')');
		$this->addSql('INSERT INTO `user_acl` VALUES (\'1\', \'1\', \'1\', \'1\', \'1\')');
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE user_acl DROP FOREIGN KEY FK_57960C9932FB8AEA');
		$this->addSql('ALTER TABLE user_acl DROP FOREIGN KEY FK_57960C9989329D25');
		$this->addSql('ALTER TABLE user_acl DROP FOREIGN KEY FK_57960C99D60322AC');
		$this->addSql('ALTER TABLE user_role DROP FOREIGN KEY FK_2DE8C6A3727ACA70');
		$this->addSql('ALTER TABLE user_roles DROP FOREIGN KEY FK_54FCD59FD60322AC');
		$this->addSql('ALTER TABLE user_roles DROP FOREIGN KEY FK_54FCD59FA76ED395');

		$this->addSql('DROP TABLE user_acl');
		$this->addSql('DROP TABLE user_privilege');
		$this->addSql('DROP TABLE user_resource');
		$this->addSql('DROP TABLE user_role');
		$this->addSql('DROP TABLE user');
	}
}
