<?php declare(strict_types = 1);

namespace Users\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="user_acl")
 * @ORM\Entity
 * @ORM\EntityListeners({"AclListener"})
 */
class Acl
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var Role
	 * @ORM\ManyToOne(targetEntity="Role")
	 * @ORM\JoinColumn(name="role_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $role;

	/**
	 * @var Privilege
	 * @ORM\ManyToOne(targetEntity="Privilege")
	 * @ORM\JoinColumn(name="privilege_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $privilege;

	/**
	 * @var Resource
	 * @ORM\ManyToOne(targetEntity="Resource")
	 * @ORM\JoinColumn(name="resource_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $resource;

	/**
	 * @var int
	 * @ORM\Column(name="allowed", type="smallint")
	 */
	protected $allowed;

	public function __construct($role, $resource, $privilege, $allowed = 1)
	{
		$this->role      = $role;
		$this->resource  = $resource;
		$this->privilege = $privilege;
		$this->allowed   = $allowed;
	}
}
