<?php declare(strict_types = 1);

namespace Users\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use Navigations\Model\BaseItem;

abstract class BaseNavigation extends BaseItem
{
	protected $langBase = 'users.navigationBuilder';

	public function presenterActionCheck($presenter, $action)
	{
		return $this->presenter == $presenter && $this->action == $action;
	}

	public function routerIn($navigation, $urlParams = [])
	{
		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => null,
		];
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		return $navigation->isHomepage ? '' : '/' . $navigation->alias;
	}
}
