<?php declare(strict_types = 1);

namespace Users\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Exception;
use Nette\Forms\Form;
use Nette\Utils\ArrayHash;
use Users\Model\UserManager;
use Users\Model\Users;

class ForgotPasswordForm extends BaseControl
{
	public function __construct(protected Users $usersService, protected UserManager $userManager)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax();

		$form->addEmail('email', 'login.forgotPasswordForm.email')
			->setAttribute('placeholder', 'login.forgotPasswordForm.email')
			->setRequired();

		$form->addSubmit('submit');

		$form->onValidate[] = $this->formOnValidate(...);
		$form->onSuccess[]  = $this->formSuccess(...);

		return $form;
	}

	public function formOnValidate(Form $form, ArrayHash $values): void
	{
		$user = $this->usersService->getByEmail($values->email);

		if (!$user) {
			$form->addError('login.forgotPasswordForm.notExists');
			$this->redrawControl('form');
		}
	}

	public function formSuccess(Form $form, ArrayHash $values): void
	{
		$presenter = $this->presenter;

		try {
			$this->userManager->createForgotPasswordAction($values->email);

			$this->flashMessage('usersFront.forgotPasswordForm.sent');
			$form->reset();
			$this->redrawControl('form');
		} catch (Exception) {
			$form->addError('usersFront.forgotPasswordForm.error');

			$this->redrawControl('form');
		}
	}

}
