<?php declare(strict_types = 1);

namespace Users\AdminModule\Presenters;

use Doctrine\ORM\NonUniqueResultException;
use Nette\Application\BadRequestException;
use Users\AdminModule\Components\IRolesGridFactory;
use Users\AdminModule\Components\IUserFormFactory;
use Users\AdminModule\Components\IUsersGridFactory;
use Users\AdminModule\Components\RolesGrid;
use Users\AdminModule\Components\UserForm;
use Users\AdminModule\Components\UsersGrid;
use Users\Model\Users;

class DefaultPresenter extends BasePresenter
{
	public function __construct(protected Users $usersService)
	{
		parent::__construct();
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault(): void
	{
		$this->setTitle($this->translator->translate('users.title.users'));
		$this->setHeader('users.title.users', 'fa fa-user-friends');
		$this['navigation']->setData(['header' => [
			[
				'title' => 'users.menu.addUser',
				'link'  => 'Default:add',
				'ico'   => 'plus',
			], [
				'title'    => 'users.menu.addRole',
				'link'     => 'Roles:add',
				'ico'      => 'plus',
				'security' => [
					'Users:Admin' => ['rolesManager'],
				],
			],
		]]);
	}

	public function actionAdd(): void
	{
		$this->setTitle($this->translator->translate('users.title.newUser'));
		$this->setHeader('users.title.newUser', 'fa fa-user-friends');
	}

	/**
	 * @throws NonUniqueResultException
	 * @throws BadRequestException
	 */
	public function actionEdit(int|string $id): void
	{
		$user = null;
		if (!$id || !($user = $this->usersService->get($id))) {
			$this->error('users.userNotFound');
		}

		$this->setTitle($this->translator->translate('users.title.editUser'), $user->getName());
		$this->setHeader('users.title.editUser', 'fa fa-user-friends');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentUsersGrid(IUsersGridFactory $factory): UsersGrid
	{
		return $factory->create();
	}

	protected function createComponentUserForm(IUserFormFactory $factory): UserForm
	{
		$control = $factory->create();

		if ($this->getParameter('id')) {
			$control->setUser($this->getParameter('id'));
		}

		$control['form']->onSuccess['redirect'] = function(): never {
			$this->redirect('default');
		};
		$control['form']->onCancel['redirect']  = function(): never {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentRolesGrid(IRolesGridFactory $factory): RolesGrid
	{
		return $factory->create();
	}
}
