<?php declare(strict_types = 1);

namespace Users\AdminModule\Presenters;

use Core\AdminModule\Presenters\BasePresenter;
use Users\AdminModule\Components\ForgotPasswordForm;
use Users\AdminModule\Components\IForgotPasswordFormFactory;
use Users\AdminModule\Components\ILoginFormFactory;
use Users\AdminModule\Components\INewPasswordFormFactory;
use Users\AdminModule\Components\LoginForm;
use Users\AdminModule\Components\NewPasswordForm;

class LoginPresenter extends BasePresenter
{

	protected function startup(): void
	{
		if ($this->getUser()->isLoggedIn()) {
			$this->redirect(':Dashboard:Admin:Default:');
		}

		parent::startup();
	}

	public function beforeRender(): void
	{
		parent::beforeRender();
		$this->setTitle($this->t('login.title'));
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */
	public function actionNewPassword(?string $token, ?string $email): void { }

	public function renderForgotPassword(): void
	{
		$this->setTitle($this->t('login.titleForgotPassword'));
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentLoginForm(ILoginFormFactory $factory): LoginForm
	{
		return $factory->create();
	}

	protected function createComponentForgotPasswordForm(IForgotPasswordFormFactory $factory): ForgotPasswordForm
	{
		return $factory->create();
	}

	protected function createComponentNewPasswordForm(INewPasswordFormFactory $factory): NewPasswordForm
	{
		return $factory->create();
	}
}
