<?php declare(strict_types = 1);

namespace Users\AdminModule\Presenters;

use Doctrine\ORM\NonUniqueResultException;
use Nette\Application\BadRequestException;
use Users\AdminModule\Components\IProfileFormFactory;
use Users\AdminModule\Components\ProfileForm;
use Users\Model\Users;

class ProfilePresenter extends BasePresenter
{
	public function __construct(protected Users $usersService)
	{
		parent::__construct();
	}


	/*******************************************************************************************************************
	 * ==================================   Actions
	 */
	/**
	 * @throws NonUniqueResultException
	 * @throws BadRequestException
	 */
	public function actionDefault(int|string|null $id): void
	{
		if (!$id || !($user = $this->usersService->get($id))) {
			$this->error('users.userNotFound');
		}

		$this->template->account = $user;
		$this->setTitle($this->translator->translate('users.title.myProfile'));
		$this->setHeader('users.title.myProfile', 'fa fa-user-friends');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentProfileForm(IProfileFormFactory $factory): ProfileForm
	{
		$control = $factory->create();
		if ($this->getParameter('id')) {
			$control->onAnchor[] = function() use ($control) {
				$control->setUser($this->getParameter('id'));
			};
		}

		$control['form']->onSuccess['redirect'] = function(): never {
			$this->redirect('this');
		};

		$control['form']->onCancel['redirect'] = function(): never {
			$this->redirect('Default:');
		};

		return $control;
	}
}
